/*
 * Decompiled with CFR 0.152.
 */
package com.dinzeer.srelic.entity;

import com.dinzeer.srelic.registry.ParticleHelper;
import com.dinzeer.srelic.registry.SREntiteRegristrys;
import java.util.ArrayList;
import java.util.List;
import mods.flammpfeil.slashblade.entity.Projectile;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.minecraftforge.registries.ForgeRegistries;

public class BlackHole
extends Projectile {
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(BlackHole.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    List<Entity> trackingEntities = new ArrayList<Entity>();
    private int soundTick;
    private float damage;
    private static final int loopSoundDurationInTicks = 320;

    public BlackHole(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BlackHole(Level pLevel, LivingEntity owner) {
        this((EntityType<? extends Projectile>)((EntityType)SREntiteRegristrys.BLACK_HOLE.get()), pLevel);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getDamage() {
        return this.damage;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)(this.getRadius() * 2.0f));
    }

    public void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(5.0f));
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_RADIUS.equals(pKey)) {
            this.m_6210_();
            if (this.getRadius() < 0.1f) {
                this.m_146870_();
            }
        }
        super.m_7350_(pKey);
    }

    public void setRadius(float pRadius) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Math.min(pRadius, 48.0f)));
        }
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128350_("Radius", this.getRadius());
        pCompound.m_128405_("Age", this.f_19797_);
        pCompound.m_128350_("Damage", this.getDamage());
        super.m_7380_(pCompound);
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.f_19797_ = pCompound.m_128451_("Age");
        this.damage = pCompound.m_128457_("Damage");
        if (this.damage == 0.0f) {
            this.damage = 1.0f;
        }
        if (pCompound.m_128451_("Radius") > 0) {
            this.setRadius(pCompound.m_128457_("Radius"));
        }
        super.m_7378_(pCompound);
    }

    public static boolean isFriendlyFireBetween(Entity attacker, Entity target) {
        if (attacker == null || target == null) {
            return false;
        }
        if (attacker.m_20365_(target)) {
            return true;
        }
        Team team = attacker.m_5647_();
        if (team != null) {
            return team.m_83536_(target.m_5647_()) && !team.m_6260_();
        }
        return attacker.m_7307_(target);
    }

    public void m_8119_() {
        super.m_8119_();
        int update = Math.max((int)(this.getRadius() / 2.0f), 2);
        if (this.f_19797_ % update == 0) {
            this.updateTrackingEntities();
        }
        AABB bb = this.m_20191_();
        float radius = (float)bb.m_82362_();
        boolean hitTick = this.f_19797_ % 10 == 0;
        for (Entity entity : this.trackingEntities) {
            Vec3 center;
            float distance;
            if (entity == this.m_19749_() || BlackHole.isFriendlyFireBetween(this.m_19749_(), entity) || (distance = (float)(center = bb.m_82399_()).m_82554_(entity.m_20182_())) > radius) continue;
            float f = 1.0f - distance / radius;
            float scale = f * f * f * f * 0.25f;
            Vec3 diff = center.m_82546_(entity.m_20182_()).m_82490_((double)scale);
            entity.m_5997_(diff.f_82479_, diff.f_82480_, diff.f_82481_);
            if (hitTick && distance < 9.0f && this.m_5603_(entity)) {
                entity.f_19802_ = 0;
                Level level = entity.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    entity.m_6469_(new DamageSource((Holder)serverLevel.m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268433_), this.m_19749_()), 3.0f);
                }
            }
            entity.f_19789_ = 0.0f;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ > 640) {
                this.m_146870_();
                this.m_9236_().m_5594_(null, BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_()), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.ender_dragon.growl")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                BlackHole.spawnParticles(this.m_9236_(), ParticleHelper.UNSTABLE_ENDER, this.m_20185_(), this.m_20186_() + (double)this.getRadius(), this.m_20189_(), 200, 1.0, 1.0, 1.0, 1.0, true);
            } else if ((this.f_19797_ - 1) % 320 == 0) {
                BlackHole.spawnParticles(this.m_9236_(), ParticleHelper.UNSTABLE_ENDER, this.m_20185_(), this.m_20186_() + (double)this.getRadius(), this.m_20189_(), 200, 1.0, 1.0, 1.0, 1.0, true);
            }
        }
    }

    public static void spawnParticles(Level level, ParticleOptions particle, double x, double y, double z, int count, double deltaX, double deltaY, double deltaZ, double speed, boolean force) {
        level.m_7654_().m_6846_().m_11314_().forEach(player -> ((ServerLevel)level).m_8624_(player, particle, force, x, y, z, count, deltaX, deltaY, deltaZ, speed));
    }

    private void updateTrackingEntities() {
        this.trackingEntities = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(1.0));
    }

    public boolean m_6051_() {
        return false;
    }
}

